import 'dart:convert';

import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:play_lab/constants/my_strings.dart';
import 'package:play_lab/core/helper/string_format_helper.dart';
import 'package:play_lab/data/model/authorization/authorization_response_model.dart';
import 'package:play_lab/data/model/global/response_model/response_model.dart';
import 'package:play_lab/data/model/request/recent_request_response_model.dart';
import 'package:play_lab/data/model/request/search_request_response_model.dart';
import 'package:play_lab/data/repo/request/request_repo.dart';
import 'package:play_lab/view/components/show_custom_snackbar.dart';

class MakeRequestController extends GetxController {
  RequestRepo repo;
  MakeRequestController({required this.repo});

  TextEditingController detailsController = TextEditingController();

  List<RecentItem> items = [];
  List<SearchItem> searchItems = [];
  bool isLoading = false;
  Future<void> initialValue() async {
    isLoading = true;
    isSubmitLoading = false;
    items = [];
    searchItems = [];
    update();
    await recentRequest();
    isLoading = false;
    update();
  }

  Future<void> recentRequest() async {
    try {
      ResponseModel responseModel = await repo.recentRequest();
      if (responseModel.statusCode == 200) {
        final model = recentRequestResponseModelFromJson(responseModel.responseJson);
        if (model.status == "success") {
          items = model.data?.items ?? [];
        } else {
          CustomSnackbar.showCustomSnackbar(errorList: [responseModel.message], msg: [], isError: true);
        }
      } else {
        CustomSnackbar.showCustomSnackbar(errorList: [responseModel.message], msg: [], isError: true);
      }
    } catch (e) {
      printX(e);
    }
  }

  bool isSearching = false;
  Future<void> searchRequest(String text) async {
    isSearching = true;
    update();
    try {
      ResponseModel responseModel = await repo.searchRequest(text);
      if (responseModel.statusCode == 200) {
        final model = searchRequestResponseModelFromJson(responseModel.responseJson);
        if (model.status == "success") {
          searchItems = model.data?.allItems ?? [];
          update();
        } else {
          CustomSnackbar.showCustomSnackbar(errorList: model.message?.error ?? [MyStrings.somethingWentWrong], msg: [], isError: true);
        }
      } else {
        CustomSnackbar.showCustomSnackbar(errorList: [responseModel.message], msg: [], isError: true);
      }
    } catch (e) {
      printX(e);
    }
    isSearching = false;
    update();
  }

  bool isSubmitLoading = false;
  Future<void> makeRequest(SearchItem item) async {
    isSubmitLoading = true;
    update();
    try {
      ResponseModel responseModel = await repo.makeRequest(item: item, recommend: detailsController.text);
      if (responseModel.statusCode == 200) {
        AuthorizationResponseModel model = AuthorizationResponseModel.fromJson(jsonDecode(responseModel.responseJson));
        if (model.status == "success") {
          detailsController.text = '';
          Get.back();
          CustomSnackbar.showCustomSnackbar(errorList: [], msg: [model.message?.success?.first ?? MyStrings.success], isError: false);
        } else {
          CustomSnackbar.showCustomSnackbar(errorList: model.message?.error ?? [MyStrings.somethingWentWrong], msg: [], isError: true);
        }
      } else {}
    } catch (e) {
      printX(e);
    }
    isSubmitLoading = false;
    update();
  }
}
